function MqVoteExtension(iID,strRecordDocRef, objRequest, oCenMn, lngFldVoteOnBehalfOfID, blnAllowDelegateVote)
{
	var m_iID=iID;
    var vost_NotRequiredToVoteInStatus = 0
    var vost_RequiredToVote_NotVotedYet = -1

	var MSG_SAVE_VOTE=g_MqRef.RESX['VOTING.WARNING_MESSAGE_THANKS_VOTE'];

	var VOTING_BUTTONS_DIV="divButtons" + m_iID;
	// The whole voting UI
	var VOTINGAREA_DIV="divVotingArea" + m_iID;

	var CHECK_VOTE_URI_CALL="wcCmdBar.ASP?wci=wciIsVoteRequired";
	var GET_DELEGATES_URI_CALL="GetDelegateFor.asp?";
	
	// BUTTONS
	var BTN_YES="btnActionY" + m_iID;
	var BTN_NO="btnActionN" + m_iID;

	var VOTE_APPROVED = 1;
	var VOTE_REJECTED = 2;

	// If true, nothing will be displayed when there is no voting required for the current user.
	var m_bHideIfNotRequiredToVote=true;	
	
	var CBO_VOTE_AS="cboVoteAs" + m_iID;
	
	// MESSAGES
	var MSG_VOTED_YES="divMsgVotedYes" + m_iID;
	var MSG_VOTED_NO="divMsgVotedNo" + m_iID;
	var MSG_NO_VOTING="divMsgNoVotingRequired" + m_iID;
			
	var mobjRequest=objRequest;
	var m_strRecordDocRef=strRecordDocRef;
	var mobjRecordDoc;
	var m_oCenMn = oCenMn;	// reference to Cen Main library
	var m_strOnBehalfOf="";
	var m_lngFldVoteOnBehalfOfID=lngFldVoteOnBehalfOfID;
	var m_blnAllowDelegateVote=blnAllowDelegateVote;
	
	function OnAfterLoadRec()
	{
		SetPossibleVoters();
		VerifyVotingStatus();
	}
	
	function SetPossibleVoters()
	{
		var arrVoters=new Array();
		var objDoc=eval(m_strRecordDocRef);
		var objFormElement=new CMqFormElement();
			
		if(objDoc){
			var objVoterList=objDoc.getElementById(CBO_VOTE_AS);
			if(objVoterList)
			{
				arrVoters.push(new Array(m_oCenMn.m_strCurrentUserFullName, m_oCenMn.m_strCurrentUserFullName));
				if(m_blnAllowDelegateVote){
					var strDelegates=mobjRequest.Get(GET_DELEGATES_URI_CALL);
					if(strDelegates!=""){
						var arrDelegates=strDelegates.split(";");
						for(x=0; x<arrDelegates.length; x++){
							var strDelegate=arrDelegates[x];
							arrVoters.push(new Array(strDelegate, strDelegate));
						}
						objFormElement.HideElement(false, null, true, CBO_VOTE_AS, objDoc);
					}else{
						objFormElement.HideElement(true, null, true, CBO_VOTE_AS, objDoc);
					}
				}
			}	
			objVoterList.disabled=false;
			objFormElement.SetPossibleValues(arrVoters, true, objVoterList, CTRL_TYPE_COMBO);
		}
	}
	
	function VerifyVotingStatus()
	{
		WriteConsole("MqVoteExtension: Verifying the voting status for the current user...");
		try{
			
			var objFormElement=new CMqFormElement();
			objFormElement.Initialize(CBO_VOTE_AS,CTRL_TYPE_COMBO,m_strRecordDocRef);
			
			m_strOnBehalfOf=objFormElement.GetValue();
			
			if(m_oCenMn)
			{
				if(m_oCenMn.objRecord)
				{
					var iRecID=m_oCenMn.objRecord.GetRecordId() ;
					if ( iRecID> 0)
					{
	
						sCurrentVote=mobjRequest.Get(CHECK_VOTE_URI_CALL + "&nId=" + iRecID +
							"&UN=" + g_MqRef.MqStr.MqEncodeURIComponent(m_strOnBehalfOf));
			
						UpdateVotingUI(sCurrentVote);
					}
				}
			}
			SetDelegateDetails();
			
		}catch(err)
		{
			WriteConsole(err + ", URL: " + CHECK_VOTE_URI_CALL)
		}		
	}

	function UpdateVotingUI(sVote)
	{
		var iVote=parseInt(sVote);
		mobjRecordDoc=eval(m_strRecordDocRef);
		if(mobjRecordDoc){
			WriteConsole("MqVoteExtension: Updating the voting buttons to reflect voting status:" + iVote);
								
			switch (iVote){
			case vost_NotRequiredToVoteInStatus:
				// not required to vote
				mobjRecordDoc.getElementById(VOTING_BUTTONS_DIV).style.display = "none";
				mobjRecordDoc.getElementById(MSG_VOTED_YES).style.display = "none";
				mobjRecordDoc.getElementById(MSG_VOTED_NO).style.display = "none";
				mobjRecordDoc.getElementById(MSG_NO_VOTING).style.display = "";
				break;
			
			case vost_RequiredToVote_NotVotedYet:
				// not voted yet
				mobjRecordDoc.getElementById(VOTING_BUTTONS_DIV).style.display = "";
				mobjRecordDoc.getElementById(MSG_VOTED_YES).style.display = "none";
				mobjRecordDoc.getElementById(MSG_VOTED_NO).style.display = "none";
				mobjRecordDoc.getElementById(MSG_NO_VOTING).style.display = "none";
				break;

			case VOTE_APPROVED:
				// voted yes 
				mobjRecordDoc.getElementById(VOTING_BUTTONS_DIV).style.display = "none";
				mobjRecordDoc.getElementById(MSG_VOTED_YES).style.display = "";
				mobjRecordDoc.getElementById(MSG_VOTED_NO).style.display = "none";
				mobjRecordDoc.getElementById(MSG_NO_VOTING).style.display = "none";
				break;

			case VOTE_REJECTED:
				// voted yes 
				mobjRecordDoc.getElementById(VOTING_BUTTONS_DIV).style.display = "none";
				mobjRecordDoc.getElementById(MSG_VOTED_YES).style.display = "none";
				mobjRecordDoc.getElementById(MSG_VOTED_NO).style.display = "";
				mobjRecordDoc.getElementById(MSG_NO_VOTING).style.display = "none";
				break;
			}
			
			if ((iVote==vost_NotRequiredToVoteInStatus) && m_bHideIfNotRequiredToVote){
				mobjRecordDoc.getElementById(VOTINGAREA_DIV).style.display = "none";
			}else{
				mobjRecordDoc.getElementById(VOTINGAREA_DIV).style.display = "";
			}
		}
		return true;

	}

	function Vote(bApproved, lngFldVoteID)
	{
		if(m_oCenMn){
			if(m_oCenMn.objRecord){
				if (m_oCenMn.objRecord.GetRecordId() > 0){
					var objField=m_oCenMn.g_VWS.ViewFields().Field(lngFldVoteID);
					var objFormElement=new CMqFormElement();
					objFormElement.Initialize(objField.GetBoundControl(),objField.GetControlType(),m_strRecordDocRef);
					
					if(bApproved){
						objFormElement.SetValue(VOTE_APPROVED);
						UpdateVotingUI(VOTE_APPROVED);
					}else{
						objFormElement.SetValue(VOTE_REJECTED);
						UpdateVotingUI(VOTE_REJECTED);
					}
					var objDoc=eval(m_strRecordDocRef);
					
					if(objDoc){
						var objCtrl=objDoc.getElementById(objField.GetBoundControl());
						if(objCtrl){
							if(objCtrl.onchange){
								objCtrl.onchange();
							}
						}
					}
					m_oCenMn.OnRecordChanged(lngFldVoteID);
					
					var objVoterList=objDoc.getElementById(CBO_VOTE_AS);
					if(objVoterList)
					{
						objVoterList.disabled=true;
					}
					
					try{
					if (mobjRecordDoc.getElementById(this.ApprovalCommentsCtlName)) {				
						mobjRecordDoc.getElementById(this.ApprovalCommentsCtlName).focus();	
					}
					}catch(e){
					}
				}
			}
		}
	}
	
	function SetDelegateDetails()
	{
		if(m_lngFldVoteOnBehalfOfID){
			var objField=m_oCenMn.g_VWS.ViewFields().Field(m_lngFldVoteOnBehalfOfID);
			if(objField){
				var objFormElement=new CMqFormElement();
				objFormElement.Initialize(objField.GetBoundControl(),objField.GetControlType(),m_strRecordDocRef);
				objFormElement.SetValue(m_strOnBehalfOf);
			}
		}
	}
	
	this.Name="MqVoteExtension 7.05.0518";
	this.OnAfterLoadRec=OnAfterLoadRec;
	this.Vote=Vote;
	this.ApprovalCommentsCtlName="";
	this.VerifyVotingStatus=VerifyVotingStatus;
	
	WriteConsole("MqVoteExtension: Initializing the extension " + this.Name);
		
}
